using System;
using System.Collections.Generic;

class Program
{
    static bool NoOverflow(int a, int b)
    {
        unchecked
        {
            var result = a * b;
            return result / b == a;
        }
    }

    static void Main()
    {
        var brojUpita = int.Parse(Console.ReadLine());
        for (int i = 0; i < brojUpita; i++)
        {
            var preprekeIVojnici = Console.ReadLine().Split(' ');
            var brojPrepreka = int.Parse(preprekeIVojnici[0]);
            var vojnici = int.Parse(preprekeIVojnici[1]);

            var mnozenja = Console.ReadLine().Split(' ');
            var sabiranja = Console.ReadLine().Split(' ');
            var donjeGranice = Console.ReadLine().Split(' ');
            var gornjeGranice = Console.ReadLine().Split(' ');

            var moguciRezultati = new HashSet<int> { vojnici };
            var noviRezultati = new HashSet<int>();

            for (int j = 0; j < brojPrepreka; j++)
            {
                foreach (var trenutniVojnici in moguciRezultati)
                {
                    var zaMnozenje = int.Parse(mnozenja[j]);
                    var zaSabiranje = int.Parse(sabiranja[j]);
                    var zaDonju = int.Parse(donjeGranice[j]);
                    var zaGornju = int.Parse(gornjeGranice[j]);

                    var zbir = trenutniVojnici + zaSabiranje;
                    if (zbir >= zaDonju && zbir <= zaGornju)
                    {
                        noviRezultati.Add(zbir);
                    }

                    if (NoOverflow(trenutniVojnici, zaMnozenje))
                    {
                        var proizvod = trenutniVojnici * zaMnozenje;
                        if (proizvod >= zaDonju && proizvod <= zaGornju)
                        {
                            noviRezultati.Add(proizvod);
                        }
                    }
                }

                moguciRezultati.Clear();
                moguciRezultati.UnionWith(noviRezultati);
                noviRezultati.Clear();
            }

            if(moguciRezultati.Count == 0)
            {
                Console.WriteLine("nemoguce");
            }
            else
            {
                var maks = int.MinValue;
                foreach(var moguci in moguciRezultati)
                {
                    maks = Math.Max(maks, moguci);
                }
                Console.WriteLine(maks);
            }
        }
    }
}